/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class Screenshot {
    public static void takeScreenshot(String fileName) {
        int width = Display.getWidth();
        int height = Display.getHeight();
        ByteBuffer buffer = BufferUtils.createByteBuffer(width * height * 4);
        GL11.glReadPixels(0, 0, width, height, 6408, 5121, buffer);
        BufferedImage image = new BufferedImage(width, height, 2);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i2 = (x + (height - y - 1) * width) * 4;
                int r = buffer.get(i2) & 0xFF;
                int g2 = buffer.get(i2 + 1) & 0xFF;
                int b2 = buffer.get(i2 + 2) & 0xFF;
                int a2 = buffer.get(i2 + 3) & 0xFF;
                int argb = a2 << 24 | r << 16 | g2 << 8 | b2;
                image.setRGB(x, y, argb);
                ++x;
            }
            ++y;
        }
        try {
            File file = new File(fileName);
            file.getParentFile().mkdirs();
            boolean success = ImageIO.write((RenderedImage)image, "PNG", file);
            if (success) {
                System.out.println("Screenshot saved: " + file.getAbsolutePath());
            } else {
                System.err.println("Failed to save screenshot (ImageIO.write returned false)");
            }
        }
        catch (IOException e2) {
            System.err.println("Failed to save screenshot!");
            e2.printStackTrace();
        }
    }

    public static void takeScreenshotDated() {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        Screenshot.takeScreenshot("screenshots/dz_" + timestamp + ".png");
    }

    public static void screenshot() {
        Screenshot.takeScreenshotDated();
    }
}

